#include <bits/stdc++.h>

using namespace std;

struct Fenwick {
    int n;
    vector<int> fw;
    Fenwick(int _n) {
        n = _n;
        fw.resize(n);
        for(int i = 0; i < n; i++) fw[i] = 0;
    }
    void update(int x, int val) { for(int i = x; i < n; i += (i & -i)) fw[i] += val; }
    int get(int x) {
        int ans = 0;
        for(int i = x; i >= 1; i -= (i & -i)) ans += fw[i];
        return ans;
    }
};

const int N = 5e5 + 10;
int n;
int p[N], q[N], R[N];
int posp[N], posq[N];
vector<int> g[N];
vector<int> topo;
bool mark[N], skip[N];
int comp;

void dfs(int u) {
    if(mark[u]) return;
    mark[u] = true;
    comp++;
    for(int v : g[u]) {
        if(mark[v]) continue;
        dfs(v);
    }
    topo.push_back(u);
}

void Formacija(int _n, int* _p, int* _q, int* R, long long& Slabost){
    n = _n;
    for(int i = 1; i <= n; i++) {
        skip[i] = true;
        p[i] = _p[i];
        q[i] = _q[i];
        posp[p[i]] = i;
        posq[q[i]] = i;
    }
    if(n <= 10) {
        Slabost = 1e9;
        int a[n + 1];
        for(int i = 1; i <= n; i++) a[i] = i;
        do {
            int np[n + 1], nq[n + 1];
            for(int i = 1; i <= n; i++) {
                np[i] = a[p[i]];
                nq[i] = a[q[i]];
            }
            int cnt1 = 0, cnt2 = 0;
            for(int i = 1; i <= n; i++) {
                for(int j = i + 1; j <= n; j++) {
                    if(np[i] > np[j]) cnt1++;
                    if(nq[i] > nq[j]) cnt2++;
                }
            }
            if(max(cnt1, cnt2) < Slabost) {
                Slabost = max(cnt1, cnt2);
                for(int i = 1; i <= n; i++) R[i] = a[i];
            }
        } while(next_permutation(a + 1, a + n + 1));
        return;
    }
    for(int i = 1; i <= n; i++) q[posq[p[i]]] = i;
    for(int i = 1; i <= n; i++) p[i] = i;
    long long good = 0;
    Fenwick fw(n + 1);
    for(int i = 1; i <= n; i++) {
        good += fw.get(q[i] - 1);
        fw.update(q[i], 1);
    }
    Slabost = (n * 1LL * (n - 1) / 2 - good + 1) / 2;
}
/*

3
1 2 3
3 1 2

*/